# TürkHost MySQL Sunucusu Kurulum Rehberi

Bu rehber, TürkHost'tan alınan uzak MySQL sunucusuna Ticket System'i kurmak için hazırlanmıştır.

## 📋 Ön Hazırlık

### 1. TürkHost'tan Alınan Bilgiler

TürkHost kontrol panelinden (cPanel) şu bilgileri almanız gerekiyor:

- ✅ **MySQL Host (Sunucu Adresi)**: Genellikle `localhost` veya `mysql.turkhost.com` gibi
- ✅ **MySQL Port**: Genellikle `3306`
- ✅ **Veritabanı Adı**: cPanel'den oluşturduğunuz veritabanı adı
- ✅ **Kullanıcı Adı**: Veritabanı kullanıcı adı
- ✅ **Şifre**: Veritabanı kullanıcı şifresi

### 2. Veritabanı Oluşturma (cPanel)

1. TürkHost cPanel'e giriş yapın
2. **MySQL Databases** veya **Veritabanları** bölümüne gidin
3. Yeni veritabanı oluşturun (örnek: `ticketsys_db`)
4. Yeni kullanıcı oluşturun veya mevcut kullanıcıyı seçin
5. Kullanıcıya veritabanına **TÜM YETKİLERİ** verin (ALL PRIVILEGES)
6. Veritabanı adı, kullanıcı adı ve şifreyi not edin

**Önemli:** TürkHost genellikle veritabanı adına ve kullanıcı adına ön ek ekler (örn: `kullanici_ticketsys_db`)

## 🔧 .env Dosyası Yapılandırması

Proje klasöründe `.env` dosyasını oluşturun veya düzenleyin:

```env
APP_NAME="Ticket System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://yourdomain.com

LOG_CHANNEL=stack
LOG_LEVEL=error

# TürkHost MySQL Ayarları
DB_CONNECTION=mysql
DB_HOST=localhost
# veya uzak sunucu ise: mysql.turkhost.com
# veya IP adresi: 123.45.67.89
DB_PORT=3306
DB_DATABASE=kullanici_ticketsys_db
DB_USERNAME=kullanici_dbuser
DB_PASSWORD=your_strong_password

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

# Email Ayarları (TürkHost SMTP)
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=noreply@yourdomain.com
MAIL_PASSWORD=email_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@yourdomain.com"
MAIL_FROM_NAME="Ticket System"

VITE_APP_NAME="Ticket System"
```

### DB_HOST Notları:

- **Yerel sunucu (shared hosting)**: Genellikle `localhost`
- **Uzak MySQL sunucusu**: TürkHost'un verdiği host adresi (örn: `mysql.turkhost.com` veya IP adresi)
- **Port**: Genellikle `3306` (TürkHost farklı bir port kullanıyorsa onu yazın)

## 📦 Kurulum Adımları

### 1. Dosyaları Sunucuya Yükleyin

FTP veya cPanel File Manager ile tüm dosyaları sunucuya yükleyin:

```
/public_html/
  ├── app/
  ├── bootstrap/
  ├── config/
  ├── database/
  ├── public/
  ├── resources/
  ├── routes/
  ├── storage/
  ├── vendor/
  ├── .env
  ├── artisan
  ├── composer.json
  └── ...
```

**Önemli:** 
- `vendor/` klasörünü yerelde `composer install` ile oluşturup yükleyin
- `node_modules/` klasörünü yüklemeyin (gerekli değil)
- `.env` dosyasını mutlaka yükleyin ama içinde şifreler olduğu için dikkatli olun

### 2. Composer Bağımlılıklarını Yükleyin

**Yerel bilgisayarınızda:**
```bash
composer install --no-dev --optimize-autoloader
```

Sonra `vendor/` klasörünü sunucuya yükleyin.

**VEYA sunucuda SSH erişiminiz varsa:**
```bash
cd /home/kullanici/public_html
composer install --no-dev --optimize-autoloader
```

### 3. Uygulama Anahtarı

Sunucuda SSH ile veya cPanel Terminal ile:
```bash
php artisan key:generate
```

### 4. Veritabanı Migration'ları

```bash
php artisan migrate --force
```

`--force` parametresi production ortamında çalıştırmak için gereklidir.

### 5. Storage Link

```bash
php artisan storage:link
```

Bu komut `public/storage` klasörünü `storage/app/public` ile bağlar.

### 6. (Opsiyonel) Varsayılan Kullanıcılar

```bash
php artisan db:seed --force
```

Veya manuel olarak admin kullanıcısı oluşturun (aşağıya bakın).

## 🔐 İlk Admin Kullanıcısı Oluşturma

### Yöntem 1: Seeder ile
```bash
php artisan db:seed --force
```

### Yöntem 2: Manuel (cPanel phpMyAdmin)

1. cPanel'den **phpMyAdmin**'e girin
2. Veritabanınızı seçin
3. `users` tablosuna gidin
4. **Insert** sekmesine tıklayın
5. Şu değerleri girin:

```sql
name: Admin
email: admin@yourdomain.com
password: (bcrypt hash - aşağıdaki komutu kullanın)
role: admin
```

**Şifre hash'i oluşturmak için:**
```bash
php artisan tinker
```
Sonra:
```php
Hash::make('your_password')
```
Çıkan hash'i kopyalayıp password alanına yapıştırın.

### Yöntem 3: SQL ile

phpMyAdmin'de SQL sekmesine gidin ve çalıştırın:

```sql
INSERT INTO users (name, email, password, role, created_at, updated_at) 
VALUES (
    'Admin', 
    'admin@yourdomain.com', 
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 
    'admin', 
    NOW(), 
    NOW()
);
```

**Not:** Yukarıdaki hash `password` şifresine ait. Güvenlik için kendi şifrenizin hash'ini oluşturun.

## 🌐 Sunucu Yapılandırması

### .htaccess Dosyası (public klasöründe)

`public/.htaccess` dosyası zaten mevcut olmalı. Eğer yoksa oluşturun:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

### Dosya İzinleri

SSH ile veya cPanel File Manager ile:

```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
chown -R kullanici:kullanici storage
chown -R kullanici:kullanici bootstrap/cache
```

## 📧 Email Yapılandırması (TürkHost SMTP)

TürkHost SMTP ayarları genellikle şöyledir:

```env
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=noreply@yourdomain.com
MAIL_PASSWORD=email_account_password
MAIL_ENCRYPTION=tls
```

cPanel'den **Email Accounts** bölümünden email hesabı oluşturabilirsiniz.

## ✅ Kontrol Listesi

Kurulumdan sonra kontrol edin:

- [ ] `.env` dosyası doğru yapılandırıldı
- [ ] `APP_KEY` oluşturuldu
- [ ] Veritabanı bağlantısı çalışıyor (`php artisan migrate` başarılı)
- [ ] `storage/` ve `bootstrap/cache/` klasörleri yazılabilir
- [ ] `public/storage` linki oluşturuldu
- [ ] Admin kullanıcısı oluşturuldu
- [ ] Email ayarları yapıldı
- [ ] Site erişilebilir durumda

## 🔍 Sorun Giderme

### "Access denied for user" Hatası

1. cPanel'den kullanıcı adı ve şifreyi kontrol edin
2. Kullanıcının veritabanına erişim yetkisi olduğundan emin olun
3. `DB_HOST` değerini kontrol edin (genellikle `localhost`)

### "Unknown database" Hatası

1. Veritabanının cPanel'den oluşturulduğundan emin olun
2. `DB_DATABASE` adının tam halini yazın (ön ek dahil)
3. Kullanıcının veritabanına erişim yetkisi olduğundan emin olun

### "Class not found" veya "500 Error"

1. `composer install` komutunu çalıştırdığınızdan emin olun
2. `vendor/` klasörünün yüklendiğinden emin olun
3. `APP_KEY` oluşturulduğundan emin olun

### Dosya Yükleme Hatası

1. `storage/` klasörü yazılabilir olmalı (`chmod 755`)
2. `php artisan storage:link` komutunu çalıştırın
3. PHP `upload_max_filesize` ve `post_max_size` ayarlarını kontrol edin

## 📞 Destek

Sorun yaşarsanız:
1. Laravel log dosyalarını kontrol edin: `storage/logs/laravel.log`
2. PHP hata loglarını kontrol edin (cPanel'den)
3. `.env` dosyasındaki tüm değerleri tekrar kontrol edin

## 🎉 Başarılı Kurulum Sonrası

Kurulum tamamlandıktan sonra:

1. **Admin paneline giriş yapın:** `/admin/dashboard`
2. **Ayarları yapın:** `/admin/settings`
   - Logo yükleyin
   - SEO ayarlarını yapın
   - Timezone'u ayarlayın
3. **Knowledge Base ekleyin:** `/admin/knowledgebase`
4. **İlk ticket'ı test edin**

Başarılar! 🚀

